﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SynoGet
{
    public partial class HelpWindow : Form
    {
        public HelpWindow()
        {
            InitializeComponent();
            
            StringBuilder strB = new StringBuilder();
            strB.Append("SynoGet 0.4 © 2008-2012 - Björn Weber\n");
            strB.Append("Command line tool that queues downloads on a Synology Diskstation (with Firmware >= DSM 4.0-2198).\n");
            strB.Append("\n");
            strB.Append("Usage: SynoGet.exe downloadurl [/ds_protocol:value] [/ds_ip:value] [/ds_port:value]\n");
            strB.Append("\t[/ds_path_login:value] [/ds_path_download:value]\n");
            strB.Append("\t[/ds_username:value] [/ds_password:value] [/passwordinplaintext] [/debug]\n");
            strB.Append("                                       \n");
            strB.Append("\tdownloadurl \t\tThe URL that should be queued on the diskstation.\n");
            strB.Append("\t/ds_protocol:value\t\tOptional. value sets the protocol of the \n");
            strB.Append("\t\t\t\t\tdiskstation webinterface. \n");
            strB.Append("\t\t\t\t\tValid values: http, https\n");
            strB.Append("\t\t\t\t\tDefault: https\n");
            strB.Append("\t/ds_ip:value\t\tOptional. value sets the IP adress (or DNS name) of the diskstation.\n");
            strB.Append("\t\t\t\t\tOptional, because it can be set in \n");
            strB.Append("\t\t\t\t\ta 'SynoGet.exe.config' file(see below)\n");
            strB.Append("\t/ds_port:value\t\tOptional. value sets the port of the diskstation webinterface.\n");
            strB.Append("\t\t\t\t\tDefault: 5001\n");
            strB.Append("\t/ds_path_login:value\t\tOptional. value sets the path to the login.cgi\n");
            strB.Append("\t\t\t\t\tof the diskstation webinterface.\n");
            strB.Append("\t\t\t\t\tDefault: webman/login.cgi\n");
            strB.Append("\t/ds_path_download:value\tOptional. value sets the path to the downloadman.cgi\n");
            strB.Append("\t\t\t\t\tof the diskstation webinterface.\n");
            strB.Append("\t\t\t\t\tDefault: webman/3rdparty/DownloadStation\n");
            strB.Append("\t\t\t\t\t\t\t /dlm/downloadman.cgi\n");
            strB.Append("\t/ds_username:value\tOptional. value sets the username for whom the\n");
            strB.Append("\t\t\t\t\tdownload should be queued.\n");
            strB.Append("\t/ds_password:value\tOptional. values sets the (base64-'encrypted') password\n");
            strB.Append("\t\t\t\t\tof the user.\n");
            strB.Append("\t/passwordinplaintext\tOptional. If set, the /ds_password switch will\n");
            strB.Append("\t\t\t\t\taccept un-'encrypted' passwords.\n");
            strB.Append("\t/debug\t\t\tOptional. If set, SynoGet will write a SynoGetDebug.txt file\n");
            strB.Append("\t\t\t\t\tin the current directory.\n\n");
            strB.Append("Example: \n");
            strB.Append("\tSynoGet.exe http://www.BjoernWeber.net/SynoGet/SynoGet-0.4.zip /ds_ip:192.168.1.11 \n");
            strB.Append("\t/ds_username:bjoern /ds_password:cGFzc3dvcmQ=\n");
            strB.Append("\n\n");
            strB.Append("All /ds_* switches can be statically set in a SynoGet.exe.config file, which must be in the same directory \n");
            strB.Append("as the SynoGet.exe file. The commandline will always overwrite this config. For example: \n\n");
            strB.Append("\t<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            strB.Append("\t<configuration>\n");
            strB.Append("\t\t<appSettings>\n");
            strB.Append("\t\t\t<add key=\"ds_ip\" value=\"192.168.1.11\" />\n");
            strB.Append("\t\t</appSettings>\n");
            strB.Append("\t</configuration>\n\n");
            strB.Append("If you like SynoGet, please donate (PayPal).\n\n");
            strB.Append("Thank you! Have Fun! Björn");

            richTextBoxHelpText.Text = strB.ToString();
        }

        private void buttonDonate_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=Z99RNGKDQ8YPC");
        }
    }
}
